/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.io.IOException;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.screen.AlarmScreen;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.Slider;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import org.lwjgl.input.Mouse;

public class AlarmOptionsScreen
extends GuiScreen
implements Slider.ISlider {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/alarm_options.png");
    private static final ResourceLocation RESET_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset.png");
    private static final ResourceLocation RESET_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset_inactive.png");
    private final String soundLengthText = new TextComponentTranslation("gui.securitycraft:alarm.sound_length", new Object[0]).func_150255_a(new Style().func_150228_d(Boolean.valueOf(true))).func_150254_d();
    private final String title = Utils.localize("options.title", new Object[0]).func_150254_d();
    private final AlarmScreen alarmScreen;
    private int imageWidth = 226;
    private int imageHeight = 112;
    private int leftPos;
    private int topPos;
    private GuiButton minusMinute;
    private GuiButton minusTenSeconds;
    private GuiButton minusSecond;
    private GuiButton reset;
    private GuiButton plusSecond;
    private GuiButton plusTenSeconds;
    private GuiButton plusMinute;
    private SoundLengthEditBox soundLengthEditBox;
    private Slider pitchSlider;
    private int soundLengthTextXPosition;

    public AlarmOptionsScreen(AlarmScreen alarmScreen) {
        this.alarmScreen = alarmScreen;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.leftPos = (this.field_146294_l - this.imageWidth) / 2;
        this.topPos = (this.field_146295_m - this.imageHeight) / 2;
        this.updateAlarmScreenSizes();
        int buttonHeight = 13;
        int buttonsX = this.leftPos + 5;
        int buttonY = this.topPos + 40;
        int timeEditBoxWidth = 34;
        int soundLengthTextWidthPlusBuffer = this.field_146289_q.func_78256_a(this.soundLengthText) + 5;
        int combinedTextAndBoxWidth = soundLengthTextWidthPlusBuffer + timeEditBoxWidth;
        int id = 0;
        this.field_146292_n.add(new ClickButton(id++, this.leftPos + this.imageWidth - 12, this.topPos + 4, 8, 8, "x", b -> this.field_146297_k.func_147108_a((GuiScreen)this.alarmScreen)));
        this.soundLengthTextXPosition = this.field_146294_l / 2 - combinedTextAndBoxWidth / 2;
        this.soundLengthEditBox = new SoundLengthEditBox(id++, this.field_146289_q, this.soundLengthTextXPosition + soundLengthTextWidthPlusBuffer, buttonY - 15, timeEditBoxWidth, 12);
        this.soundLengthEditBox.func_175205_a(string -> string.matches("[0-9:]*"));
        this.minusMinute = this.func_189646_b((GuiButton)new ClickButton(id++, buttonsX, buttonY, 32, buttonHeight, new TextComponentTranslation("gui.securitycraft:alarm.minus_one_minute", new Object[0]).func_150254_d(), b -> this.changeSoundLength(-60)));
        this.minusTenSeconds = this.func_189646_b((GuiButton)new ClickButton(id++, buttonsX + 34, buttonY, 32, buttonHeight, new TextComponentTranslation("gui.securitycraft:alarm.minus_ten_seconds", new Object[0]).func_150254_d(), b -> this.changeSoundLength(-10)));
        this.minusSecond = this.func_189646_b((GuiButton)new ClickButton(id++, buttonsX + 68, buttonY, 32, buttonHeight, new TextComponentTranslation("gui.securitycraft:alarm.minus_one_second", new Object[0]).func_150254_d(), b -> this.changeSoundLength(-1)));
        this.reset = this.func_189646_b((GuiButton)new PictureButton(id++, buttonsX + 102, buttonY, 12, buttonHeight, RESET_INACTIVE_TEXTURE, 10, 10, 1, 2, 10, 10, 10, 10, b -> this.changeSoundLength(0)){

            @Override
            public ResourceLocation getTextureLocation() {
                return this.field_146124_l ? RESET_TEXTURE : RESET_INACTIVE_TEXTURE;
            }
        });
        this.plusSecond = this.func_189646_b((GuiButton)new ClickButton(id++, buttonsX + 116, buttonY, 32, buttonHeight, new TextComponentTranslation("gui.securitycraft:alarm.plus_one_second", new Object[0]).func_150254_d(), b -> this.changeSoundLength(1)));
        this.plusTenSeconds = this.func_189646_b((GuiButton)new ClickButton(id++, buttonsX + 150, buttonY, 32, buttonHeight, new TextComponentTranslation("gui.securitycraft:alarm.plus_ten_seconds", new Object[0]).func_150254_d(), b -> this.changeSoundLength(10)));
        this.plusMinute = this.func_189646_b((GuiButton)new ClickButton(id++, buttonsX + 184, buttonY, 32, buttonHeight, new TextComponentTranslation("gui.securitycraft:alarm.plus_one_minute", new Object[0]).func_150254_d(), b -> this.changeSoundLength(60)));
        this.setSoundLength(this.alarmScreen.soundLength);
        this.pitchSlider = (Slider)this.func_189646_b((GuiButton)new Slider(Utils.localize("gui.securitycraft:alarm.pitch", "" + this.alarmScreen.pitch).func_150254_d(), Utils.getLanguageKeyDenotation(SCContent.alarm), id++, this.leftPos + this.imageWidth / 2 - 50, buttonY + 25, 100, 20, Utils.localize("gui.securitycraft:alarm.pitch", "").func_150254_d(), 0.5, 2.0, this.alarmScreen.pitch, true, this));
    }

    private void updateAlarmScreenSizes() {
        int oldLeftPos = this.alarmScreen.leftPos;
        int oldTopPos = this.alarmScreen.topPos;
        this.alarmScreen.field_146294_l = this.field_146294_l;
        this.alarmScreen.field_146295_m = this.field_146295_m;
        this.alarmScreen.leftPos = (this.alarmScreen.field_146294_l - this.alarmScreen.imageWidth) / 2;
        this.alarmScreen.topPos = (this.alarmScreen.field_146295_m - this.alarmScreen.imageHeight) / 2;
        int leftDifference = this.alarmScreen.leftPos - oldLeftPos;
        int topDifference = this.alarmScreen.topPos - oldTopPos;
        this.alarmScreen.soundList.updateSize(leftDifference, topDifference);
        this.alarmScreen.searchBar.field_146209_f += leftDifference;
        this.alarmScreen.searchBar.field_146210_g += topDifference;
        this.alarmScreen.optionsButton.field_146128_h += leftDifference;
        this.alarmScreen.optionsButton.field_146129_i += topDifference;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.alarmScreen.func_73863_a(Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.soundLengthEditBox.func_146194_f();
        this.field_146289_q.func_78276_b(this.title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.title) / 2, this.topPos + 6, 0x404040);
        this.field_146289_q.func_78276_b(this.soundLengthText, this.soundLengthTextXPosition, this.topPos + 27, 0x404040);
        if (this.alarmScreen.be.isPowered() && !this.alarmScreen.be.isDisabled()) {
            int cooldownSeconds = (this.alarmScreen.be.getCooldown() - 1) / 20;
            String nextSoundText = Utils.localize("gui.securitycraft:alarm.nextSound", String.format("%02d:%02d", cooldownSeconds / 60, cooldownSeconds % 60 + 1)).func_150254_d();
            this.field_146289_q.func_78276_b(nextSoundText, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(nextSoundText) / 2, this.topPos + 95, 0x404040);
        }
    }

    public void setSoundLength(int newSoundLength) {
        this.setSoundLength(newSoundLength, true);
    }

    public void changeSoundLength(int soundLengthChange) {
        if (soundLengthChange == 0) {
            this.setSoundLength(this.alarmScreen.previousSoundLength, true);
        } else {
            this.setSoundLength(this.alarmScreen.soundLength + soundLengthChange, true);
        }
    }

    public void setSoundLength(int newSoundLength, boolean updateTimeEditBox) {
        boolean enableMinusButtons;
        int soundLength = Math.max(1, Math.min(newSoundLength, 3600));
        if (updateTimeEditBox) {
            this.soundLengthEditBox.func_146180_a(String.format("%02d:%02d", soundLength / 60, soundLength % 60));
        }
        boolean enablePlusButtons = soundLength < 3600;
        this.minusMinute.field_146124_l = enableMinusButtons = soundLength > 1;
        this.minusTenSeconds.field_146124_l = enableMinusButtons;
        this.minusSecond.field_146124_l = enableMinusButtons;
        this.reset.field_146124_l = soundLength != this.alarmScreen.previousSoundLength;
        this.plusSecond.field_146124_l = enablePlusButtons;
        this.plusTenSeconds.field_146124_l = enablePlusButtons;
        this.plusMinute.field_146124_l = enablePlusButtons;
        this.alarmScreen.soundLength = soundLength;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.soundLengthEditBox.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        double mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        double mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.soundLengthEditBox.isHovered(mouseX, mouseY) && Mouse.getEventDWheel() != 0) {
            this.soundLengthEditBox.mouseScrolled(Mouse.getEventDWheel());
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.soundLengthEditBox.func_146201_a(typedChar, keyCode);
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.func_147108_a((GuiScreen)this.alarmScreen);
        }
    }

    public boolean func_73868_f() {
        return this.alarmScreen.func_73868_f();
    }

    public void func_146281_b() {
        this.soundLengthEditBox.checkAndProcessInput();
        super.func_146281_b();
    }

    @Override
    public void onChangeSliderValue(Slider slider, String denotation, int id) {
        slider.field_146126_j = slider.getPrefix() + this.getTruncatedSliderValue(slider);
    }

    @Override
    public void onMouseRelease(int id) {
        this.alarmScreen.pitch = this.getTruncatedSliderValue(this.pitchSlider);
    }

    private float getTruncatedSliderValue(Slider slider) {
        return (float)Math.floor(slider.getValue() * 100.0) / 100.0f;
    }

    public class SoundLengthEditBox
    extends GuiTextField {
        public SoundLengthEditBox(int id, FontRenderer font, int x, int y, int width, int height) {
            super(id, font, x, y, width, height);
        }

        public void mouseScrolled(double delta) {
            AlarmOptionsScreen.this.changeSoundLength((int)Math.signum(delta));
        }

        public boolean func_146201_a(char typedChar, int keyCode) {
            if (this.func_146206_l() && keyCode == 28 || keyCode == 156) {
                this.checkAndProcessInput();
            }
            return super.func_146201_a(typedChar, keyCode);
        }

        public void func_146195_b(boolean focused) {
            if (this.func_146206_l() && !focused) {
                this.checkAndProcessInput();
            }
            super.func_146195_b(focused);
        }

        public void checkAndProcessInput() {
            int minutes = 0;
            int seconds = 2;
            if (this.field_146216_j != null && !this.field_146216_j.isEmpty()) {
                if (!this.field_146216_j.contains(":")) {
                    int numeric = Integer.parseInt(this.field_146216_j);
                    minutes = numeric / 60;
                    seconds = numeric % 60;
                } else {
                    String[] split = this.field_146216_j.split(":");
                    if (split.length == 2) {
                        if (!split[0].isEmpty()) {
                            try {
                                minutes = Integer.parseInt(split[0]);
                            }
                            catch (NumberFormatException e) {
                                minutes = 60;
                            }
                        }
                        if (!split[1].isEmpty()) {
                            try {
                                seconds = Integer.parseInt(split[1]);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            seconds = 0;
                        }
                    }
                }
            }
            AlarmOptionsScreen.this.setSoundLength(minutes * 60 + seconds, true);
            this.func_146202_e();
        }

        public boolean isHovered(double mouseX, double mouseY) {
            return mouseX >= (double)this.field_146209_f && mouseX <= (double)(this.field_146209_f + this.field_146218_h) && mouseY >= (double)this.field_146210_g && mouseY <= (double)(this.field_146210_g + this.field_146219_i);
        }
    }
}

